# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 4
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR4_strategy.txt
# LLM Suggested Fallback: C

def benevolent_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    total_rounds = len(my_history) + 1
    last_opp_move = opp_history[-1]
    
    # Detect naive patterns in opponent's code
    always_c = "return 'c'" in opponent_program_code.lower() or "always cooperate" in opponent_program_code.lower()
    always_d = "return 'd'" in opponent_program_code.lower() or "always defect" in opponent_program_code.lower()
    
    if always_c:
        return "D"
    if always_d:
        return "C" if total_rounds <= 8 else "D"
    
    # Initial phase: cooperate for first 3 rounds
    if total_rounds <= 3:
        return "C"
    
    # Middle phase: adapt based on opponent's behavior
    if 4 <= total_rounds <= 7:
        coop_count = opp_history.count("C")
        defect_count = len(opp_history) - coop_count
        if defect_count > 1:
            return last_opp_move
        else:
            return "C"
    
    # Late phase: exploit or continue tit-for-tat
    if total_rounds >= 8:
        total_defects = opp_history.count("D")
        if total_defects <= 1:
            return "D" if total_rounds >= 9 else "C"
        else:
            return last_opp_move
    
    return "C"